#! /usr/bin/env python
import os, sys
##################################################

# directory_name must be the same as module_name
module_name = 'SSM'

exclude = ['.DS_Store', '*.pyc', '*.swp']

##################################################


def ShellCmd( cmd ) : 
	return os.popen(cmd).read().split('\n')[:-1]

pwd = os.getcwd()
dir_name = pwd[pwd.rfind('/')+1:]
if (dir_name != module_name) : 
	raise Exception('directory_name must be the same as module_name, but now dir_name="'+dir_name+'", module_name="'+module_name+'"')

# python3 can get the python_version correctly, but python2 get []
#python_version = ShellCmd('python -V')[0][7:10]  # for python3
python_version = 'Python '+'.'.join([str(i) for i in sys.version_info[:3]])

# dest, without / at the end
pythoncmd = python_version.lower().replace(' ','')
pythoncmd = pythoncmd[:pythoncmd.rfind('.')]
whichpython = ShellCmd('which '+pythoncmd)[0].split('/')
whichpython = '/'+whichpython[1]+'/'

# syspath, usrpath
syspath = None
for i in range(len(sys.path)) : 
	if (sys.path[i][:len(whichpython)]==whichpython and sys.path[i][-9:]=='-packages') : 
		syspath = sys.path[i] + '/'
		if ('python'+python_version in syspath):
			break

key = '/lib64/' if('/lib64/' in syspath)else '/lib/'
usrpath = '~/.local/lib/'+syspath.split(key)[1]
#usrpath = '~/Library/Python/2.7/lib/python/site-packages/'
usrpathpwd = os.path.abspath(os.path.expanduser(usrpath))

home = os.path.expanduser('~')

fixpath = None
for argv in sys.argv[1:] : 
	if (argv[:9] == '--prefix=') : fixpath = argv[9:]
	else : continue
	fixpathpwd = os.path.abspath(os.path.expanduser(fixpath))
	fixpath = fixpathpwd
	if (fixpath[:len(home)] == home) : fixpath = '~'+fixpath[len(home):]
	if (fixpath[-1] != '/') : fixpath += '/'

syspath += module_name
usrpath += module_name
if (fixpath is not None) : fixpath += module_name

whoami = ShellCmd('whoami')[0]
if (whoami == 'root') : 
	dest = syspath
	envlist = []
elif (fixpath is None) : 
	dest = usrpath
	if (usrpathpwd[:len(home)] == home) : usrpathpwd = '$HOME'+usrpathpwd[len(home):]
	envlist = ['export PYTHONPATH="'+usrpathpwd+'"']
else : 
	dest = fixpath
	if (fixpathpwd[:len(home)] == home) : fixpathpwd = '$HOME'+fixpathpwd[len(home):]
	envlist = ['export PYTHONPATH="'+fixpathpwd+'"']


##################################################


def HELP() : 
	print('--------------- Path: ---------------')
	print('DefaultPath     : '+syspath)
	print('UsrPath         : '+usrpath)
	print('Destination     : '+dest)
	if (envlist) : print('Add environment : '+envlist[0])
	print('--------------- Usage: ---------------')
	print('./setup.py install [--user]  : install '+module_name)
	print('./setup.py install --prefix= : install to a specific destination')
	print('./setyp.py unstall           : uninstall '+module_name)
	exit()

if ((len(sys.argv) == 1) or ('-h' in sys.argv) or ('--help' in sys.argv)) : HELP()


if ('install' in sys.argv) : which = 'install'
elif ('uninstall' in sys.argv) : which = 'uninstall'

if (pwd[-len(module_name):] != module_name) : 
	print('Error: please run  ./setup.py install  inside the directory "'+module_name+'/"')
	exit()


##################################################



# python setup.py --gen_pip_install
def Gen_PipInstall(in_txtname, save=None):
	in_txtname = os.path.abspath(os.path.expanduser(in_txtname))
	n = in_txtname.rfind('.txt')
	if (n <0): n = len(in_txtname)
	out_txtname = in_txtname[:n]+'_pip_install.txt'
	if (out_txtname[:len(home+'/')] ==home+'/'):
		out_txtname2 = '~'+out_txtname[len(home):]
	else: out_txtname2 = out_txtname
	#----------------------------------------
	with open(in_txtname, 'r') as fo:
		txt = fo.readlines()
	txt2 = []
	for s in txt:
		if (s[0] in ['#','@']): continue
		s = s.split(' ')[0].split('(')[0].replace('\n','')
		txt2.append(s)
	txt2.sort()  # Sort
	txt2 = '\n'.join(txt2)
	print('Saving '+out_txtname2)
	with open(out_txtname, 'w') as fo:
		fo.write(txt2)


if ('--gen_pip_install' in sys.argv):
	n = sys.argv.index('--gen_pip_install')
	try: in_txtname = sys.argv[n+1]
	except: in_txtname = 'requirements.txt'
	Gen_PipInstall(in_txtname)
	exit()





# uninstall
elif (which == 'uninstall') : 
	print('Uninstall from  '+dest)
	opt = '-rm'  # remove from the PYTHONPATH
	dest = os.path.abspath(os.path.expanduser(dest))
	if (os.path.exists(dest)) : 
		os.system('/bin/rm -rf '+dest)



elif (which == 'install') : 
	print('Install to  '+dest)
	# Check pwd
	if (pwd[-len(module_name):] != module_name) : 
		print('Error: please run  ./setup.py install  inside the directory "'+module_name+'/"')
		exit()
	opt = '-add'  # add to the PYTHONPATH
	dest = os.path.abspath(os.path.expanduser(dest))
	destdir = dest[:dest.rfind('/')]
	if (not os.path.exists(destdir)): os.makedirs(destdir)
	# rm old
	if (os.path.exists(dest)) : 
		os.system('/bin/rm -rf '+dest)
	# install
	os.system('/bin/cp -r ../'+module_name+' '+dest)
	#----------------------------------------
	# Generate tags
#	outdir = home + 'tagsdir/'
#	if (not os.path.exists(outdir)) : os.mkdir(outdir)
#	os.chdir(dest)
#	os.system('python ptags.py '+dest+'/*.py')
#	os.system('mv tags '+module_name+'.tags')
#	os.system('cp '+module_name+'.tags '+outdir)
#	outname = home+'tags'
#	if (os.path.exists(outname)): os.system('/bin/rm '+outname)
#	fn = os.popen('ls '+outdir+'*.tags').readlines()
#	tags = []
#	for i in range(len(fn)) : 
#		tags += open(fn[i][:-1]).readlines()
#	tags.sort()  # Must sort, otherwaise useless
#	outname = open(outname, 'w')
#	for tag in tags : outname.write(tag)
#	outname.close()
#	#----------------------------------------
#	os.system('cp Vision/OpencvInstaller.py ~/bin/OpencvInstaller')
#	os.system('chmod +x ~/bin/OpencvInstaller')


##################################################


def Sysenv(*args):
	'''
	os.system('python Basic/sysenv.py '+opt+' '+which+" '"+env+"'")

	Function:
		Provide 1 command: 
			sysenv: is used to "add" or "remove" the environment in .bashrc
	
	Usage, examples:
		sysenv -add alias 'cpnot="~/bin/cmdnot.py cp"'
		sysenv -rm  alias 'cpnot="~/bin/cmdnot.py cp"'
	
	NOTE THAT, can NOT write as:
		sysenv -add alias cpnot="~/bin/cmdnot.py cp"
			--> cpnot="~/bin/cmdnot.py cp" is not an valid argument, will raise error: syntax error near unexpected token `('
			--> use '' or "" to make it to be an unity
	
		sysenv -add export "PYTHONPATH=/python2.7/site-packages/"
		sysenv -rm  export 'PYTHONPATH="/python2.7/site-packages/"'
	'''
	import os, sys
#	argv = sys.argv
	argv = ['sysenv.py']+list(args)
	
	def ShellCmd( cmd ) : 
		strlist = os.popen(cmd).readlines()
		for i in range(len(strlist)): strlist[i] = strlist[i][:-1]
		return strlist
	
	
	
	# Environment
	try : 
		pm = argv[1].lower()
		which = argv[2]
		env = argv[3]
	except : 
		print('Error, must be:    sysenv  -add/-rm  export/alias  envvalue')
		exit()
	
	envkey = env[:env.index('=')]
	envvalue = env[env.index('=')+1:]
	if (envvalue[0] == "'") : envvalue = '"'+envvalue[1:-1]+'"'
	if (envvalue[0] != '"') : envvalue = '"'+envvalue+'"'
	
	if (which=='export' and envvalue[-2]=='/') : envvalue = envvalue[:-2]+'"' # rm /
	
	
	
	# List
	font = which+' '+envkey+'='
	env1 = font+ envvalue[:-1]+'/"' +'\n'  # +" +/
	env2 = font+ envvalue +'\n'  # +" -/
	env3 = font+ envvalue[1:-1]+'/' +'\n'  # -" +/
	env4 = font+ envvalue[1:-1] +'\n'  # -" -/
	if (which == 'export') : 
		back = ':$'+envkey
		env5 = font+ envvalue[:-1]+'/'+back+'"' +'\n'  # +" +/
		env6 = font+ envvalue[:-1]+back+'"' +'\n'  # +" -/
		env7 = font+ envvalue[1:-1]+'/'+back +'\n'  # -" +/
		env8 = font+ envvalue[1:-1]+back +'\n'  # -" -/
		envlist = [env1, env2, env3, env4, env5, env6, env7, env8]
	else : envlist = [env2, env4]
	
	
	
	# Read .bash
	uname = ShellCmd('uname')[0]
	if (uname =='Darwin'):
		bash = '~/.bash_profile'
	elif (uname =='Linux'):
		bash = '~/.bashrc'
	bash = os.path.expanduser(bash)
	if (not os.path.exists(bash)) : os.system('touch '+bash)
	
	txt = open(bash).readlines()
	while (txt[-1] == '\n') : txt.pop(-1)
	
	
	
	# Remove
	if (pm.lower() in ['-rm', '-remove', '--rm', '--remove']) : 
		for i in range(len(envlist)) : 
			while (envlist[i] in txt) : txt.remove(envlist[i])
		while (txt[-1] == '\n') : txt.pop(-1)
		open(bash, 'w').writelines(txt)
		os.system('source '+bash)
	#	exit()
	
	
	
	# Add
	envexist = False
	for i in range(len(envlist)) : 
		if (envlist[i] in txt) : envexist = True
#	if (envexist) : exit()
	
	if   (which == 'alias' ) : txt.append('\n'+env2)
	elif (which == 'export') : txt.append('\n'+env5)  # or env6
	
	open(bash, 'w').writelines(txt)
	os.system('source '+bash)





# Add/Remove environment
for i in range(len(envlist)) : 
	env = envlist[i]
	n1 = env.find(' ')
	for n2 in range(n1+1, len(env)) : 
		if (env[n2] != ' ') : break
	which = env[:n1]
	env = env[n2:]
#	os.system('python Basic/sysenv.py '+opt+' '+which+" '"+env+"'")
	Sysenv(opt, which, env)


##################################################


# Add ~/bin/ command
sourcefile = 'SSM.py'
bincmd = 'SSM'
if (not os.path.exists(home+'/bin')): os.mkdir(home+'/bin')
with open(sourcefile, 'r') as fo:
	txt = fo.read()
txt = '#! /usr/bin/env '+pythoncmd+'\n' +"dest = '"+dest+"'\n" +txt
fo = open(sourcefile+'_new', 'w')
fo.write(txt)
fo.close()
os.system('cp '+sourcefile+'_new '+home+'/bin/'+bincmd)
os.system('chmod +x '+home+'/bin/'+bincmd)
os.system('cp '+sourcefile+'_new '+dest+'/'+sourcefile)
os.system('/bin/rm '+sourcefile+'_new')
print('Generated a new command of `SSM`, try it with `SSM -h`')

